<?php
require_once __DIR__ . '/../config.php';

set_time_limit(60);

// Debug Portal braucht eigene Session -> sonst Logout-Kollision mit Panel
session_name('CYLONE_DEBUG');

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

function isLoggedIn(): bool
{
    return !empty($_SESSION['admin_logged_in']);
}

function requireLogin(): void
{
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
}

// Optional: GitLab User-Daten sauber abrufbar
function getGitlabUser(): ?array
{
    return $_SESSION['admin_gitlab_user'] ?? null;
}
