<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';

requireLogin();

/* Zugriff absichern */
if (!defined('DatabaseDEBUG') || DatabaseDEBUG !== true) {
    http_response_code(403);
    exit('Access denied');
}

/* Debug-Tools zentral definieren */
$tools = [
    [
        'name' => 'DB Viewer',
        'url'  => 'database.php',
    ],
    [
        'name' => 'Error Log',
        'url'  => 'errorlog.php',
    ],
    [
        'name' => 'PHP Info',
        'url'  => 'phpinfo.php',
    ],
    [
        'name' => 'TTS',
        'url'  => 'tts.php',
    ],
    [
        'name' => 'TTS v2',
        'url'  => 'tts2.php',
    ],
    [
        'name' => 'Audio Explorer',
        'url'  => 'audio_explorer.php',
    ],
    [
        'name' => 'Explorer',
        'url'  => 'explorer.php',
    ],
    [
        'name' => 'Fastfetch',
        'url'  => 'fastfetch.php',
    ],
    [
        'name' => 'Metrics',
        'url'  => 'metrics.php',
    ],
    [
        'name' => 'Einstellunen',
        'url'  => 'settings.php',
    ],
    // weitere Tools hier ergänzen
];
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Debug Tools</title>

<style>
:root{
    --bg:#0f1115;--panel:#151922;--border:#2a2f3a;
    --text:#e6e6e6;--accent:#4da3ff;
}
*{box-sizing:border-box}
body{
    margin:0;
    font-family:system-ui,sans-serif;
    background:var(--bg);
    color:var(--text);
    height:100vh;
    display:flex;
    flex-direction:column;
}

/* Header */
header{
    padding:10px 14px;
    background:var(--panel);
    border-bottom:1px solid var(--border);
    display:flex;
    gap:10px;
}

/* Tool Buttons */
header button{
    background:#1c2130;
    border:1px solid var(--border);
    color:var(--text);
    padding:6px 12px;
    cursor:pointer;
}
header button:hover{
    border-color:var(--accent);
}

/* Iframe */
#frame{
    flex:1;
    width:100%;
    border:none;
    background:#000;
}
</style>
</head>

<body>

<header>
    <?php foreach ($tools as $t): ?>
        <button onclick="loadTool('<?= htmlspecialchars($t['url']) ?>')">
            <?= htmlspecialchars($t['name']) ?>
        </button>
    <?php endforeach; ?>
</header>

<iframe id="frame" src=""></iframe>

<script>
const STORAGE_KEY = 'debug_last_tool';

function loadTool(url){
    const frame = document.getElementById('frame');
    frame.src = url;
    localStorage.setItem(STORAGE_KEY, url);
}

/* Beim Reload letzten Tab wiederherstellen */
window.addEventListener('DOMContentLoaded', () => {
    const lastTool = localStorage.getItem(STORAGE_KEY);
    if (lastTool) {
        document.getElementById('frame').src = lastTool;
    }
});
</script>


</body>
</html>
