<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/auth.php';

if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

// OAuth State (CSRF Schutz)
$state = bin2hex(random_bytes(16));
$_SESSION['oauth_state'] = $state;

$authUrl = GITLAB_BASE_URL . '/oauth/authorize?' . http_build_query([
    'client_id' => GITLAB_CLIENT_ID,
    'redirect_uri' => GITLAB_REDIRECT_URI,
    'response_type' => 'code',
    'state' => $state,
    'scope' => 'read_user read_api'
]);

header('Location: ' . $authUrl);
exit;
