<?php
function setAdminPassword(PDO $pdo, string $plainPassword): int
{
    // Passwort hashen (Pflicht)
    $hash = password_hash($plainPassword, PASSWORD_DEFAULT);

    $sql = "
        INSERT INTO einstellungen (
            schluessel,
            wert
        ) VALUES (
            :key,
            :wert
        )
        ON DUPLICATE KEY UPDATE
            wert = VALUES(wert)
    ";

    return cyldb_exec($pdo, $sql, [
        'key'  => 'admin_key',
        'wert' => $hash
    ]);
}
