#!/bin/bash

# absichtlich kein set -e (kontrollierte Fehlerbehandlung)
# set -e

export HOME="/home/wecker"
HOME_DIR="$HOME/PiClock"
VENV="$HOME_DIR/venv"
VOICES="$HOME_DIR/voices"
DEFAULT_VOICE="de_DE-thorsten-high"
AUSGABE_DIR="/var/www/html/WAV"

###############################################################################
#                                                                             #
#                              Parameter auswerten                            #
#                                                                             #
###############################################################################

MODEL="$1"
TEXT="$2"
OUT="$3"

###############################################################################
#                                                                             #
#                           Abwärtskompatibilität:                            #
#                   Falls nur 1 Argument kommt → ist es TEXT                  #
#                                                                             #
###############################################################################

if [ -z "$TEXT" ]; then
  TEXT="$MODEL"
  MODEL="$DEFAULT_VOICE"
fi

if [ -z "$TEXT" ]; then
  echo "Kein Text übergeben"
  exit 1
fi

if [ -z "$MODEL" ]; then
  MODEL="$DEFAULT_VOICE"
fi

###############################################################################
#                                                                             #
#                              Ausgabedatei                                   #
#                                                                             #
###############################################################################

if [ -z "$OUT" ]; then
  OUT="$AUSGABE_DIR/tts_$(date +%s).wav"
fi

###############################################################################
#                                                                             #
#              Voice prüfen / ggf. nachladen (nicht fatal)                    #
#                                                                             #
###############################################################################

if [ ! -d "$VOICES/$MODEL" ]; then
  "$VENV/bin/python" -m piper.download_voices "$MODEL" --data-dir "$VOICES" || true
fi

###############################################################################
#                                                                             #
#                              TTS ausführen                                  #
#                                                                             #
###############################################################################

"$VENV/bin/python" -m piper \
  -m "$MODEL" \
  --data-dir "$VOICES" \
  -f "$OUT" \
  -- "$TEXT"

EXIT_CODE=$?

if [ $EXIT_CODE -ne 0 ]; then
  echo "Piper Fehler (Exitcode $EXIT_CODE)"
  exit 2
fi

echo "OK: $OUT"
exit 0
