#!/bin/bash
################################################################################
#                                                                              #
#        Skript für Installation von DHT11 / Adafruit Libs in Python venv      #
#                                                                              #
#        Ziel: Raspberry Pi (PiClock)                                          #
#                                                                              #
################################################################################
sleep 1
clear
echo -e "INFO: DHT11 Libraries werden nun in das venv installiert"

# Projektverzeichnis
mkdir -p ~/PiClock/dht11
cd ~/PiClock/dht11 || exit 1

################################################################################
#                              venv erstellen                                  #
################################################################################
echo -e "INFO: Erstelle Python venv"

python3.13 -m venv venv

################################################################################
#                            pip aktualisieren                                 #
################################################################################
echo -e "INFO: Upgrade pip"

venv/bin/pip install --upgrade pip

################################################################################
#                       Python Libraries installieren                          #
################################################################################
echo -e "INFO: Installiere Python Libraries"

venv/bin/pip install \
  adafruit-blinka \
  adafruit-circuitpython-dht \
  adafruit-circuitpython-busdevice \
  adafruit-circuitpython-requests \
  adafruit-circuitpython-connectionmanager \
  adafruit-circuitpython-typing \
  adafruit-platformdetect \
  Adafruit-PureIO \
  pyftdi \
  pyusb \
  sysv-ipc \
  rpi-gpio \
  rpi-ws281x

################################################################################
#                                   Fertig                                     #
################################################################################
echo -e "FERTIG: Installation abgeschlossen"

# sleep ist dafür fals man mal zeit zum lesen braucht
sleep 1
