#!/bin/bash

# set -e

export HOME="/home/wecker"
HOME_DIR="$HOME/PiClock"
VENV="$HOME_DIR/venv"
VOICES="$HOME_DIR/voices"
VOICE="de_DE-thorsten-high"
AUSGABE_DIR="/var/www/html/WAV"

if [ -z "$1" ]; then
  echo "Kein Text übergeben"
  exit 1
fi

TEXT="$1"

################################################################################
#                                                                              #
#           Wenn PHP einen absoluten Pfad übergibt → direkt nutzen             #
#                                                                              #
################################################################################

if [ -n "$2" ]; then
  OUT="$2"
else
  OUT="$AUSGABE_DIR/tts_$(date +%s).wav"
fi

################################################################################
#                                                                              #
#                    Modell prüfen (ohne Script-Abbruch)                       #
#                                                                              #
################################################################################

# Wenn PHP einen absoluten Pfad übergibt → direkt nutzen
if [ ! -d "$VOICES/$VOICE" ]; then
  "$VENV/bin/python" -m piper.download_voices "$VOICE" --data-dir "$VOICES" || true
fi

################################################################################
#                                                                              #
#                                TTS ausführen                                 #
#                                                                              #
################################################################################

"$VENV/bin/python" -m piper \
  -m "$VOICE" \
  --data-dir "$VOICES" \
  -f "$OUT" \
  -- "$TEXT"

EXIT_CODE=$?

if [ $EXIT_CODE -ne 0 ]; then
  echo "Piper Fehler (Exitcode $EXIT_CODE)"
  exit 2
fi

echo "OK: $OUT"
exit 0
