<?php
http_response_code(404);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>404 – Seite nicht gefunden</title>

<style>
:root{
    --bg:#0f1115;
    --panel:#151922;
    --border:#2a2f3a;
    --text:#e6e6e6;
    --accent:#4da3ff;
    --error:#ff6b6b;
}

*{box-sizing:border-box}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:system-ui,sans-serif;
    padding:24px;
}

.box{
    background:var(--panel);
    border:1px solid var(--border);
    padding:32px;
    max-width:800px;
}

h1{
    margin-top:0;
    font-size:32px;
    color:var(--error);
}

p{
    line-height:1.5;
    color:#cfd3dc;
}

.code{
    margin-top:16px;
    padding:12px;
    background:#0f1420;
    border:1px solid var(--border);
    font-family:monospace;
    color:var(--accent);
}

button{
    margin-top:20px;
    padding:8px 18px;
    background:#1c2130;
    border:1px solid var(--border);
    color:var(--text);
    cursor:pointer;
}

button:hover{
    border-color:var(--accent);
}
</style>
</head>

<body>

<div class="box">
    <h1>404 – Seite nicht gefunden</h1>

    <p>
        Die angeforderte Ressource existiert nicht oder wurde verschoben.
        Wenn du hier gelandet bist, stimmt entweder die URL nicht oder das Ziel
        ist nicht mehr verfügbar.
    </p>

    <div class="code">
        HTTP_STATUS = 404<br>
        REQUEST_URI = <?= htmlspecialchars($_SERVER['REQUEST_URI'] ?? 'unknown') ?>
    </div>

    <a href="/">
        <button type="button">Zur Startseite</button>
    </a>
</div>

</body>
</html>
