<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';
requireLogin();
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>Fastfetch Live</title>
<style>
:root{
  --bg:#0f1115;--panel:#151922;--border:#2a2f3a;--text:#e6e6e6;--accent:#4da3ff;
}
*{box-sizing:border-box}
body{
  margin:0;background:var(--bg);color:var(--text);
  font-family:system-ui,sans-serif;padding:24px
}
.box{
  background:var(--panel);border:1px solid var(--border);
  padding:16px;max-width:1000px
}
h2{margin:0 0 10px;color:var(--accent)}
.controls{display:flex;gap:10px;margin-bottom:10px}
button{
  background:#1c2130;border:1px solid var(--border);
  color:var(--text);padding:6px 12px;cursor:pointer
}
button:hover{border-color:var(--accent)}
pre{
  background:#0f1420;border:1px solid var(--border);
  padding:12px;white-space:pre-wrap;min-height:200px
}
.small{opacity:.7;font-size:12px}
</style>
</head>
<body>

<div class="box">
  <h2>Fastfetch</h2>

  <div class="controls">
    <button onclick="start()">Start</button>
    <button onclick="stop()">Stop</button>
    <span class="small" id="status">Status: AUS</span>
  </div>

  <pre id="out">Warten…</pre>
</div>

<script>
let timer = null;

function start(){
  if (timer) return; // Mehrfachstart verhindern
  document.getElementById('status').textContent = 'Status: AN';
  tick();
  timer = setInterval(tick, 1000);
}

function stop(){
  if (!timer) return;
  clearInterval(timer);
  timer = null;
  document.getElementById('status').textContent = 'Status: AUS';
}

function tick(){
  fetch('fastfetch_api.php')
    .then(r => r.json())
    .then(d => {
      document.getElementById('out').textContent =
        `[${d.ts}] Exit: ${d.code}\n\n${d.output}`;
    })
    .catch(() => {
      document.getElementById('out').textContent = 'Fehler beim Abruf';
    });
}
</script>

</body>
</html>
