<?php
require __DIR__ . '/config.php';
require APP_ROOT . '/functions_db.php';
require APP_ROOT . '/functions_wecker.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $einstellungen = [
        'tts_modell'            => einstellung_hole('tts_modell') ?? 'de_DE-thorsten-high',
        'lautstaerke'           => einstellung_hole('lautstaerke') ?? '100',
        'lautstaerke_musik'     => einstellung_hole('lautstaerke_musik') ?? '80',
        'musik_ducking_prozent' => einstellung_hole('musik_ducking_prozent') ?? '20',
        'zeitzone'              => einstellung_hole('zeitzone') ?? 'Europe/Berlin',
        'tts_name'              => einstellung_hole('tts_name') ?? ''
    ];
    echo json_encode(['ok' => true, 'einstellungen' => $einstellungen]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$tts_modell = trim($_POST['tts_modell'] ?? '');
$lautstaerke = trim($_POST['lautstaerke'] ?? '');
$lautstaerke_musik = trim($_POST['lautstaerke_musik'] ?? '');
$musik_ducking_prozent = trim($_POST['musik_ducking_prozent'] ?? '');
$zeitzone = trim($_POST['zeitzone'] ?? '');
$tts_name = trim($_POST['tts_name'] ?? '');

if ($tts_modell !== '') {
    einstellung_setzen('tts_modell', $tts_modell);
}
if ($lautstaerke !== '') {
    $lautstaerke = max(0, min(100, (int)$lautstaerke));
    einstellung_setzen('lautstaerke', (string)$lautstaerke);
}
if ($lautstaerke_musik !== '') {
    $lautstaerke_musik = max(0, min(100, (int)$lautstaerke_musik));
    einstellung_setzen('lautstaerke_musik', (string)$lautstaerke_musik);
}
if ($musik_ducking_prozent !== '') {
    $musik_ducking_prozent = max(0, min(100, (int)$musik_ducking_prozent));
    einstellung_setzen('musik_ducking_prozent', (string)$musik_ducking_prozent);
}
if ($zeitzone !== '') {
    einstellung_setzen('zeitzone', $zeitzone);
}
einstellung_setzen('tts_name', $tts_name);

echo json_encode(['ok' => true]);
