<?php
require __DIR__ . '/config.php';
require APP_ROOT . '/functions_db.php';
require APP_ROOT . '/functions_wecker.php';

header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? $_POST['action'] ?? '';

try {
    switch ($action) {
        case 'get': {
            $id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
            if ($id <= 0) {
                echo json_encode(['ok' => false, 'error' => 'Ungültige ID']);
                exit;
            }
            $wecker = wecker_hole_komplett($id);
            if (!$wecker) {
                echo json_encode(['ok' => false, 'error' => 'Wecker nicht gefunden']);
                exit;
            }
            echo json_encode(['ok' => true, 'wecker' => $wecker]);
            exit;
        }

        case 'toggle': {
            $id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
            $aktiv = isset($_GET['aktiv']) ? (bool)(int)$_GET['aktiv'] : (isset($_POST['aktiv']) ? (bool)(int)$_POST['aktiv'] : null);
            if ($id <= 0 || $aktiv === null) {
                echo json_encode(['ok' => false, 'error' => 'id und aktiv erforderlich']);
                exit;
            }
            wecker_setze_aktiv($id, $aktiv);
            echo json_encode(['ok' => true]);
            exit;
        }

        case 'save': {
            $id = (int)($_POST['id'] ?? 0);
            $weckzeit = trim($_POST['weckzeit'] ?? '');
            $weckdatum = trim($_POST['weckdatum'] ?? '') ?: null;
            $wiederholung = trim($_POST['wiederholung'] ?? 'taeglich');
            if (!in_array($wiederholung, ['einmal', 'taeglich', 'woechentlich'], true)) {
                $wiederholung = 'taeglich';
            }
            $wochentage = isset($_POST['wochentage']) && is_array($_POST['wochentage'])
                ? array_map('intval', $_POST['wochentage'])
                : [];
            $sprachtext = trim($_POST['sprachtext'] ?? '');
            $aktiv = isset($_POST['aktiv']) ? (int)(bool)$_POST['aktiv'] : 1;

            if ($weckzeit === '' || $sprachtext === '') {
                echo json_encode(['ok' => false, 'error' => 'Weckzeit und Sprachtext sind Pflichtfelder']);
                exit;
            }

            $daten = [
                'weckzeit'    => $weckzeit,
                'weckdatum'   => $weckdatum,
                'wiederholung'=> $wiederholung,
                'wochentage'   => $wochentage,
                'sprachtext'  => $sprachtext,
                'aktiv'       => $aktiv
            ];

            $audio = [];
            $audioJson = $_POST['audio'] ?? '';
            if ($audioJson !== '') {
                $decoded = json_decode($audioJson, true);
                if (is_array($decoded)) {
                    $audio = $decoded;
                }
            }

            if ($id > 0) {
                $daten['weckdatum'] = $weckdatum;
                wecker_aktualisieren($id, $daten);
                wecker_setze_audio($id, $audio);
                echo json_encode(['ok' => true, 'id' => $id]);
            } else {
                $daten['weckdatum'] = $weckdatum;
                unset($daten['wochentage']);
                wecker_anlegen($daten);
                $newId = (int)$GLOBALS['pdo']->lastInsertId();
                if ($wiederholung === 'woechentlich' && !empty($wochentage)) {
                    wecker_setze_wochentage($newId, $wochentage);
                }
                wecker_setze_audio($newId, $audio);
                echo json_encode(['ok' => true, 'id' => $newId]);
            }
            exit;
        }

        case 'delete': {
            $id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
            if ($id <= 0) {
                echo json_encode(['ok' => false, 'error' => 'Ungültige ID']);
                exit;
            }
            wecker_loeschen($id);
            echo json_encode(['ok' => true]);
            exit;
        }

        case 'tts_custom_save': {
            $id = (int)($_POST['id'] ?? 0);
            $platzhalter = trim($_POST['platzhalter'] ?? '');
            $ersetzungstext = trim($_POST['ersetzungstext'] ?? '');
            $beschreibung = trim($_POST['beschreibung'] ?? '') ?: null;
            $aktiv = isset($_POST['aktiv']) ? (int)(bool)$_POST['aktiv'] : 1;
            $sortierung = (int)($_POST['sortierung'] ?? 0);

            if ($platzhalter === '') {
                echo json_encode(['ok' => false, 'error' => 'Platzhalter ist Pflicht']);
                exit;
            }
            if (preg_match('/^\{\{[^}]+\}\}$/', $platzhalter) !== 1) {
                $platzhalter = '{{' . $platzhalter . '}}';
            }

            $daten = [
                'platzhalter'    => $platzhalter,
                'ersetzungstext' => $ersetzungstext,
                'beschreibung'   => $beschreibung,
                'aktiv'          => $aktiv,
                'sortierung'     => $sortierung
            ];

            if ($id > 0) {
                tts_custom_aktualisieren($id, $daten);
                echo json_encode(['ok' => true, 'id' => $id]);
            } else {
                $newId = tts_custom_anlegen($daten);
                echo json_encode(['ok' => true, 'id' => $newId]);
            }
            exit;
        }

        case 'tts_custom_list': {
            $items = tts_custom_hole_alle();
            echo json_encode(['ok' => true, 'items' => $items]);
            exit;
        }

        case 'tts_custom_delete': {
            $id = (int)($_GET['id'] ?? $_POST['id'] ?? 0);
            if ($id <= 0) {
                echo json_encode(['ok' => false, 'error' => 'Ungültige ID']);
                exit;
            }
            tts_custom_loeschen($id);
            echo json_encode(['ok' => true]);
            exit;
        }

        default:
            echo json_encode(['ok' => false, 'error' => 'Unbekannte Action']);
    }
} catch (Throwable $e) {
    error_log('[api_wecker] ' . $e->getMessage());
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Serverfehler']);
}
