<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';
requireLogin();

$error = '';
$outputFile = '';
$outputFileName = '';
$duration = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $startTime = microtime(true); // Messung START

    $text = trim($_POST['tts_text'] ?? '');

    if ($text === '') {
        $error = 'Kein Text eingegeben.';
    } else {
        $wavDirFs  = '/var/www/html/WAV/';
        $wavDirUrl = '/WAV/';

        $outputFileName = 'tts_' . time() . '.wav';
        $wavFileFs  = $wavDirFs . $outputFileName;
        $wavFileUrl = $wavDirUrl . $outputFileName;

        $cmd = '/var/www/html/skripts_webseite/PythonTTS.sh '
             . escapeshellarg($text) . ' '
             . escapeshellarg($wavFileFs);

        exec($cmd . ' 2>&1', $output, $ret);

        if ($ret === 0 && file_exists($wavFileFs)) {
            $outputFile = $wavFileUrl;
        } else {
            $error = 'TTS-Generierung fehlgeschlagen.';
        }
    }

    $endTime = microtime(true); // Messung ENDE
    $duration = $endTime - $startTime;
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>TTS Debug</title>

<style>
:root{
    --bg:#0f1115;
    --panel:#151922;
    --border:#2a2f3a;
    --text:#e6e6e6;
    --accent:#4da3ff;
    --error:#ff6b6b;
}

*{box-sizing:border-box}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:system-ui,sans-serif;
    padding:24px;
}

.box{
    background:var(--panel);
    border:1px solid var(--border);
    padding:20px;
    max-width:900px;
}

h2{margin-top:0;color:var(--accent)}

textarea{
    width:100%;
    min-height:120px;
    background:#0f1420;
    color:var(--text);
    border:1px solid var(--border);
    padding:10px;
}

button{
    margin-top:12px;
    padding:8px 18px;
    background:#1c2130;
    border:1px solid var(--border);
    color:var(--text);
    cursor:pointer;
}

button:hover{border-color:var(--accent)}

.error{margin-top:12px;color:var(--error)}
audio{margin-top:12px;width:100%}

.metrics{
    margin-top:12px;
    padding:10px;
    background:#0f1420;
    border:1px solid var(--border);
    color:var(--accent);
    font-family:monospace;
}
</style>
</head>

<body>

<div class="box">
    <h2>Text-to-Speech Debug</h2>

    <form method="post">
        <textarea name="tts_text">Guten Morgen, es ist Acht Uhr.</textarea>
        <br>
        <button type="submit">Generieren</button>
    </form>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($duration !== null): ?>
        <div class="metrics">
            Laufzeit: <?= number_format($duration, 3, ',', '.') ?> Sekunden
        </div>
    <?php endif; ?>

    <?php if ($outputFile): ?>
        <h3>Audio-Ausgabe</h3>

        <audio controls>
            <source src="<?= htmlspecialchars($outputFile) ?>" type="audio/wav">
        </audio>
    <?php endif; ?>
</div>

</body>
</html>
