<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';
requireLogin();

/* Verzeichnisse */
$wavDirFs  = '/var/www/html/WAV/';
$wavDirUrl = '/WAV/';

/* WAV-Dateien einsammeln */
$files = [];
if (is_dir($wavDirFs)) {
    foreach (scandir($wavDirFs) as $f) {
        if (strtolower(pathinfo($f, PATHINFO_EXTENSION)) === 'wav') {
            $files[] = [
                'name' => $f,
                'url'  => $wavDirUrl . $f,
                'size' => filesize($wavDirFs . $f),
                'time' => filemtime($wavDirFs . $f),
            ];
        }
    }
}

/* Neueste zuerst */
usort($files, fn($a, $b) => $b['time'] <=> $a['time']);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>WAV Player</title>

<style>
:root{
    --bg:#0f1115;
    --panel:#151922;
    --border:#2a2f3a;
    --text:#e6e6e6;
    --accent:#4da3ff;
}

*{box-sizing:border-box}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:system-ui,sans-serif;
    padding:24px;
}

.box{
    background:var(--panel);
    border:1px solid var(--border);
    padding:20px;
    max-width:1000px;
}

h2{
    margin-top:0;
    color:var(--accent);
}

table{
    width:100%;
    border-collapse:collapse;
    margin-top:12px;
}

th,td{
    border:1px solid var(--border);
    padding:8px;
    text-align:left;
}

th{
    background:#1a1f2c;
}

audio{
    width:220px;
}

button{
    background:#1c2130;
    border:1px solid var(--border);
    color:var(--text);
    padding:6px 12px;
    cursor:pointer;
}

button:hover{
    border-color:var(--accent);
}

.small{
    opacity:.7;
    font-size:12px;
}
</style>
</head>

<body>

<div class="box">
    <h2>WAV Audio Player</h2>

    <?php if (empty($files)): ?>
        <p class="small">Keine WAV-Dateien gefunden.</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Datei</th>
                    <th>Abspielen</th>
                    <th>Download</th>
                    <th>Größe</th>
                    <th>Erstellt</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($files as $f): ?>
                <tr>
                    <td><?= htmlspecialchars($f['name']) ?></td>
                    <td>
                        <audio controls preload="none">
                            <source src="<?= htmlspecialchars($f['url']) ?>" type="audio/wav">
                        </audio>
                    </td>
                    <td>
                        <a href="<?= htmlspecialchars($f['url']) ?>"
                           download="<?= htmlspecialchars($f['name']) ?>">
                            <button type="button">Download</button>
                        </a>
                    </td>
                    <td class="small">
                        <?= number_format($f['size'] / 1024, 1) ?> KB
                    </td>
                    <td class="small">
                        <?= date('Y-m-d H:i:s', $f['time']) ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

</body>
</html>
