CREATE TABLE wecker (
    id INT AUTO_INCREMENT PRIMARY KEY,
    weckzeit TIME NOT NULL,
    weckdatum DATE NULL,
    wiederholung ENUM('einmal','taeglich','woechentlich') NOT NULL DEFAULT 'einmal',
    sprachtext TEXT NOT NULL,
    aktiv TINYINT(1) NOT NULL DEFAULT 1,
    zuletzt_ausgeloest DATETIME NULL,
    erstellt_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);


CREATE TABLE wecker_wochentage (
    wecker_id INT NOT NULL,
    wochentag TINYINT NOT NULL,
    PRIMARY KEY (wecker_id, wochentag),
    FOREIGN KEY (wecker_id) REFERENCES wecker(id) ON DELETE CASCADE
);

CREATE TABLE wecker_audio (
    id INT AUTO_INCREMENT PRIMARY KEY,
    wecker_id INT NOT NULL,
    datei VARCHAR(500) NOT NULL,
    titel VARCHAR(255) NULL,
    position ENUM('vorher','gleichzeitig','danach') NOT NULL,
    sortierung INT NOT NULL DEFAULT 0,
    FOREIGN KEY (wecker_id) REFERENCES wecker(id) ON DELETE CASCADE
);

CREATE TABLE einstellungen (
    schluessel VARCHAR(50) PRIMARY KEY,
    wert TEXT NOT NULL
);

CREATE TABLE tts_platzhalter (
    id INT AUTO_INCREMENT PRIMARY KEY,
    platzhalter VARCHAR(50) NOT NULL UNIQUE,
    beschreibung VARCHAR(255),
    aktiv TINYINT(1) NOT NULL DEFAULT 1,
    sortierung INT NOT NULL DEFAULT 0
);

CREATE TABLE tts_custom (
    id INT AUTO_INCREMENT PRIMARY KEY,
    platzhalter VARCHAR(50) NOT NULL UNIQUE,
    ersetzungstext TEXT NOT NULL,
    beschreibung VARCHAR(255) NULL,
    aktiv TINYINT(1) NOT NULL DEFAULT 1,
    sortierung INT NOT NULL DEFAULT 0,
    erstellt_am TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

INSERT INTO einstellungen (schluessel, wert) VALUES
('zeitzone','Europe/Berlin'),
('lautstaerke','100'),
('tts_modell','de_DE-thorsten-high');

INSERT INTO tts_platzhalter (platzhalter, beschreibung, sortierung) VALUES
('{{uhrzeit}}', 'Aktuelle Uhrzeit', 0),
('{{datum}}', 'Heutiges Datum', 1),
('{{temperatur}}', 'Aktuelle Temperatur', 2),
('{{name}}', 'Ihr hinterlegter Name', 3);

-- Optional: Beispiel benutzerdefinierter Platzhalter
-- INSERT INTO tts_custom (platzhalter, ersetzungstext, beschreibung) VALUES
-- ('{{weckername}}', 'Guten Morgen', 'Begrüßung für den Wecker');
