<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';

requireLogin();

if (!defined('LogDEBUG') || LogDEBUG !== true) {
    http_response_code(403);
    exit;
}

$logFile = defined('DEBUG_ERROR_LOG_PATH') ? DEBUG_ERROR_LOG_PATH : '/var/log/apache2/error.log';

if (!file_exists($logFile) || !is_readable($logFile)) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Logfile nicht lesbar oder nicht gefunden']);
    exit;
}

$raw = @file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
if ($raw === false) {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Logfile konnte nicht gelesen werden']);
    exit;
}

$lines = array_slice($raw, -200);
header('Content-Type: application/json');
echo json_encode($lines);
