<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/auth.php';

if (isLoggedIn()) {
    header('Location: index.php');
    exit;
}

$passwordEnabled = defined('DEBUG_PASSWORD') && DEBUG_PASSWORD !== '';

// Passwort-Login (POST)
if ($passwordEnabled && $_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['password'])) {
    if (hash_equals(DEBUG_PASSWORD, (string) $_POST['password'])) {
        $_SESSION['admin_logged_in'] = true;
        $_SESSION['admin_gitlab_user'] = [
            'id' => 0,
            'username' => 'password',
            'name' => 'Passwort-Login',
            'email' => null,
            'access_level' => 20,
        ];
        header('Location: index.php');
        exit;
    }
    $passwordError = 'Falsches Passwort.';
}

// GitLab OAuth: Weiterleitung nur wenn explizit ?gitlab angefordert
if (isset($_GET['gitlab'])) {
    $state = bin2hex(random_bytes(16));
    $_SESSION['oauth_state'] = $state;
    $authUrl = GITLAB_BASE_URL . '/oauth/authorize?' . http_build_query([
        'client_id' => GITLAB_CLIENT_ID,
        'redirect_uri' => GITLAB_REDIRECT_URI,
        'response_type' => 'code',
        'state' => $state,
        'scope' => 'read_user read_api'
    ]);
    header('Location: ' . $authUrl);
    exit;
}

$loginWithGitlabUrl = 'login.php?gitlab=1';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="utf-8">
    <title>Debug Login</title>
    <style>
        :root { --bg:#0f1115; --panel:#151922; --border:#2a2f3a; --text:#e6e6e6; --accent:#4da3ff; --error:#ff6b6b; }
        * { box-sizing: border-box; }
        body { margin: 0; font-family: system-ui, sans-serif; background: var(--bg); color: var(--text); min-height: 100vh; display: flex; align-items: center; justify-content: center; padding: 20px; }
        .card { background: var(--panel); border: 1px solid var(--border); border-radius: 12px; padding: 28px; max-width: 360px; width: 100%; }
        h1 { margin: 0 0 20px; font-size: 1.25rem; }
        .field { margin-bottom: 16px; }
        label { display: block; margin-bottom: 6px; font-size: 0.9rem; opacity: 0.9; }
        input[type="password"] { width: 100%; padding: 10px 12px; background: #1c2130; border: 1px solid var(--border); border-radius: 6px; color: var(--text); font-size: 1rem; }
        input[type="password"]:focus { outline: none; border-color: var(--accent); }
        .btn { display: inline-block; padding: 10px 18px; background: var(--accent); color: #0f1115; border: none; border-radius: 6px; font-weight: bold; cursor: pointer; font-size: 0.95rem; text-decoration: none; }
        .btn:hover { background: #6bb3ff; }
        .btn-ghost { background: transparent; color: var(--accent); border: 1px solid var(--border); margin-top: 12px; }
        .btn-ghost:hover { border-color: var(--accent); background: rgba(77,163,255,.1); }
        .error { color: var(--error); font-size: 0.9rem; margin-top: 8px; }
        .divider { margin: 20px 0; text-align: center; font-size: 0.85rem; opacity: 0.6; }
    </style>
</head>
<body>
    <div class="card">
        <h1>Debug-Portal</h1>

        <?php if ($passwordEnabled): ?>
        <form method="post" action="login.php">
            <div class="field">
                <label for="password">Passwort</label>
                <input type="password" id="password" name="password" placeholder="Passwort" autocomplete="current-password" required autofocus>
            </div>
            <?php if (!empty($passwordError)): ?><p class="error"><?= htmlspecialchars($passwordError) ?></p><?php endif; ?>
            <button type="submit" class="btn">Anmelden</button>
        </form>
        <div class="divider">— oder —</div>
        <?php endif; ?>

        <a href="<?= htmlspecialchars($loginWithGitlabUrl) ?>" class="btn btn-ghost">Mit GitLab anmelden</a>
    </div>
</body>
</html>
