<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';

requireLogin();

if (!defined('DatabaseDEBUG') || DatabaseDEBUG !== true) {
    http_response_code(403);
    exit('Access denied');
}

/* phpinfo abfangen */
ob_start();
phpinfo();
$phpinfo = ob_get_clean();

/* Styles aus phpinfo entfernen */
$phpinfo = preg_replace('#<style[^>]*>.*?</style>#si', '', $phpinfo);
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="utf-8">
<title>PHP Info</title>

<style>
:root{
    --bg:#0f1115;
    --panel:#151922;
    --border:#2a2f3a;
    --text:#e6e6e6;
    --accent:#4da3ff;
}
*{box-sizing:border-box}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:system-ui,sans-serif;
}

header{
    padding:12px 16px;
    background:var(--panel);
    border-bottom:1px solid var(--border);
    font-size:18px;
    font-weight:600;
}

/* phpinfo overrides */
#phpinfo {
    padding:16px;
}

#phpinfo table {
    width:100%;
    border-collapse:collapse;
    margin-bottom:20px;
    font-size:14px;
}

#phpinfo th,
#phpinfo td {
    border:1px solid var(--border);
    padding:6px 8px;
}

#phpinfo th {
    background:#1a1f2c;
    color:var(--accent);
    text-align:left;
}

#phpinfo td {
    background:#0f1420;
}

#phpinfo h1,
#phpinfo h2 {
    color:var(--accent);
}

#phpinfo hr {
    border:0;
    border-top:1px solid var(--border);
    margin:20px 0;
}
</style>
</head>

<body>

<header>PHP Information</header>

<div id="phpinfo">
    <?= $phpinfo ?>
</div>

</body>
</html>
