<?php
require __DIR__ . '/../config.php';
require __DIR__ . '/auth.php';
requireLogin();

$script = '/var/www/html/skripts_webseite/gitlab_update.sh';
$output = [];
$returnCode = null;
$executed = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (!file_exists($script)) {
        $error = 'Script nicht gefunden.';
    } elseif (!is_executable($script)) {
        $error = 'Script ist nicht ausführbar.';
    } else {
        $cmd = '/usr/bin/sudo ' . escapeshellarg($script);
        exec($cmd . ' 2>&1', $output, $returnCode);

        $executed = true;
    }
}
?>
<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>Settings</title>

<style>
:root{
    --bg:#0f1115;
    --panel:#151922;
    --border:#2a2f3a;
    --text:#e6e6e6;
    --accent:#4da3ff;
    --error:#ff6b6b;
    --ok:#5dff8a;
}

*{box-sizing:border-box}

body{
    margin:0;
    background:var(--bg);
    color:var(--text);
    font-family:system-ui,sans-serif;
    padding:24px;
}

.box{
    background:var(--panel);
    border:1px solid var(--border);
    padding:20px;
    max-width:900px;
}

h2{margin-top:0;color:var(--accent)}

button{
    padding:10px 20px;
    background:#1c2130;
    border:1px solid var(--border);
    color:var(--text);
    cursor:pointer;
}

button:hover{
    border-color:var(--accent);
}

.output{
    margin-top:16px;
    padding:12px;
    background:#0f1420;
    border:1px solid var(--border);
    font-family:monospace;
    white-space:pre-wrap;
}

.ok{color:var(--ok)}
.error{color:var(--error)}
</style>
</head>

<body>

<div class="box">
    <h2>Settings – Git Clone</h2>

    <form method="post">
        <button type="submit">gitclone.sh ausführen</button>
    </form>

    <?php if ($error): ?>
        <div class="output error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($executed): ?>
        <div class="output <?= $returnCode === 0 ? 'ok' : 'error' ?>">
Return-Code: <?= $returnCode ?>


<?= htmlspecialchars(implode("\n", $output)) ?>
        </div>
    <?php endif; ?>
</div>

</body>
</html>
