#!/bin/bash
################################################################################
#                                                                              #
#                 Install der Basis Toolts/Services/Libs                       #
#                                                                              #
################################################################################
clear
cowsay "INFO: Basis install Teil: "

cat << 'EOF'

   ___  _ _______         __  
  / _ \(_) ___/ /__  ____/ /__
 / ___/ / /__/ / _ \/ __/  '_/
/_/  /_/\___/_/\___/\__/_/\_\ 

EOF

sudo apt update
sudo apt full-upgrade -y 
sudo apt install apache2 fastfetch htop btop kdiskmark git iotop lm-sensors cowsay sl -y
sudo systemctl start ssh
sudo systemctl enable ssh


cat > gitclone.sh << 'EOF'
#!/bin/bash
################################################################################
#                                                                              #
#                     Skript zum clonen von Gitlab                             #
#                                                                              #
################################################################################
clear
cowsay "INFO: Git wird jetzt gepullt und eingefügt"

print_logo() {
cat <<'LOGO'
   ___  _ _______         __  
  / _ \(_) ___/ /__  ____/ /__
 / ___/ / /__/ / _ \/ __/  '_/
/_/  /_/\___/_/\___/\__/_/\_\ 
LOGO
}

################################################################################
#                                                                              #
#                              ./wecker löschen                                #
#                                                                              #
################################################################################

sudo rm -fr ./wecker

################################################################################
#                                                                              #
#               Gitlab mit Token klonen und int html moven                     #
#                                                                              #
################################################################################

if git clone https://oauth2:cylone-uuQQvchZ2_C21uGdqvbwkG86MQp1OjE5CA.01.0y0xvhcjv@gitlab.cylone-network.com/lucasschule/wecker.git; then
    echo "Git Clone erfolgreich: erstelle /var/www/html neu"
    sudo rm -rf /var/www/html
    sudo cp -r ./wecker/html /var/www/
else
    echo "FEHLER: Git Clone fehlgeschlagen: /var/www/html bleibt erhalten"
    exit 1
fi
################################################################################
#                                                                              #
#                 Rechte setzten und ./wecker wider löschen                    #
#                                                                              #
################################################################################

sudo chmod -R 777 /var/www/html
sudo rm -fr ./wecker
sudo chmod -R +x /var/www/html/skripts/*
sudo chmod -R +x /var/www/html/skripts_webseite/*

################################################################################
#                                                                              #
#                 Abfrage: Alle_skirpts.sh ausführen?                          #
#                                                                              #
################################################################################

echo
read -rp "Soll /var/www/html/Alle_skirpts.sh jetzt ausgeführt werden? (y/n): " antwort

case "$antwort" in
  j|J|ja|JA|y|Y)
    echo "INFO: Starte /var/www/html/Alle_skirpts.sh"
    sudo bash /var/www/html/Alle_skirpts.sh
    ;;
  *)
    echo "INFO: Alle_skripte.sh wurde nicht ausgeführt"
    sleep 2
    ;;
esac

EOF

cat > show_models.sh << 'EOF2'
#!/bin/bash
cd ~/PiClock
python3 -m venv venv
source venv/bin/activate
venv/bin/pip install --upgrade pip
python3 -m piper.download_voices
EOF2

################################################################################
#                                                                              #
#                     Rechte für Dateien und Ordner                            #
#                                                                              #
################################################################################

sudo chmod +x ./show_models.sh
sudo chmod +x ./gitclone.sh
sudo chmod +x /var/www/html/Alle_skirpts.sh 
sudo chmod -R 755 /home/wecker
sudo chmod -R 755 /home/wecker/PiClock
sudo usermod -aG wecker www-data
sudo chmod o+rx /var/log/apache2/
sudo chmod o+rx /var/log/apache2/error.log 

################################################################################
#                                                                              #
#                   Ausführung des gitclone Skripts                            #
#                                                                              #
################################################################################

./gitclone.sh

################################################################################
#                                                                              #
#                   Ausführung des nächsten Skripts                            #
#                                                                              #
################################################################################

clear
cowsay "INFO: Alle_skirpts.sh wird jetzt ausgeführt"
sudo chmod +x /var/www/html/Alle_skirpts.sh 
/var/www/html/Alle_skirpts.sh 

####################################################################################################################
#                                                REBOOT-ABFRAGE                                                    #
####################################################################################################################

echo
read -p "Jetzt neu starten? (y/n): " ANSWER_REBOOT

if [[ "$ANSWER_REBOOT" =~ ^[Yy]$ ]]; then
    sudo reboot
else
    echo "Neustart übersprungen. Bitte später manuell rebooten!"
fi