<?php
/**
 * Führt SQL-Dateien aus database/update aus (z. B. nach Installation/Update).
 * Nur nach Debug-Login aufrufbar.
 */
require __DIR__ . '/config.php';
require __DIR__ . '/debug/auth.php';

requireLogin();

header('Content-Type: application/json; charset=utf-8');

$result = require __DIR__ . '/run_database_updates.inc.php';

if (!empty($result['errors'])) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'errors' => $result['errors'], 'executed' => $result['executed']]);
    exit;
}

echo json_encode([
    'ok' => true,
    'message' => $result['executed'] > 0 ? 'DB-Updates ausgeführt.' : 'Keine SQL-Dateien ausgeführt.',
    'executed' => $result['executed']
]);
